/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.slot.ScalingFormula;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.spec.ClientSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.EntitySettingsConfig;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.config.type.CarriedItemTemperature;
import com.momosoftworks.coldsweat.config.type.InsulatingMount;
import com.momosoftworks.coldsweat.config.type.Insulator;
import com.momosoftworks.coldsweat.config.type.PredicateItem;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import com.momosoftworks.coldsweat.util.math.Vec2i;
import com.momosoftworks.coldsweat.util.registries.ModEntities;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import oshi.util.tuples.Triplet;

public class ConfigSettings {
    public static final BiMap<String, DynamicHolder<?>> CONFIG_SETTINGS = HashBiMap.create();
    public static final BiMap<String, DynamicHolder<?>> CLIENT_SETTINGS = HashBiMap.create();
    public static Difficulty DEFAULT_DIFFICULTY = Difficulty.NORMAL;
    public static final DynamicHolder<Difficulty> DIFFICULTY = ConfigSettings.addSyncedSetting("difficulty", () -> Difficulty.NORMAL, holder -> holder.set(Difficulty.byId(MainSettingsConfig.getInstance().getDifficulty())), encoder -> ConfigHelper.serializeNbtInt(encoder.getId(), "Difficulty"), decoder -> Difficulty.byId(decoder.m_128451_("Difficulty")), saver -> MainSettingsConfig.getInstance().setDifficulty(saver.getId()));
    public static final DynamicHolder<Double> MAX_TEMP = ConfigSettings.addSyncedSetting("max_temp", () -> 1.7, holder -> holder.set(MainSettingsConfig.getInstance().getMaxTempHabitable()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "MaxTemp"), decoder -> decoder.m_128459_("MaxTemp"), saver -> MainSettingsConfig.getInstance().setMaxHabitable((double)saver));
    public static final DynamicHolder<Double> MIN_TEMP = ConfigSettings.addSyncedSetting("min_temp", () -> 0.5, holder -> holder.set(MainSettingsConfig.getInstance().getMinTempHabitable()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "MinTemp"), decoder -> decoder.m_128459_("MinTemp"), saver -> MainSettingsConfig.getInstance().setMinHabitable((double)saver));
    public static final DynamicHolder<Double> TEMP_RATE = ConfigSettings.addSyncedSetting("temp_rate", () -> 1.0, holder -> holder.set(MainSettingsConfig.getInstance().getRateMultiplier()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "TempRate"), decoder -> decoder.m_128459_("TempRate"), saver -> MainSettingsConfig.getInstance().setRateMultiplier((double)saver));
    public static final DynamicHolder<Double> TEMP_DAMAGE = ConfigSettings.addSyncedSetting("temp_damage", () -> 2.0, holder -> holder.set(MainSettingsConfig.getInstance().getTempDamage()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "TempDamage"), decoder -> decoder.m_128459_("TempDamage"), saver -> MainSettingsConfig.getInstance().setTempDamage((double)saver));
    public static final DynamicHolder<Boolean> FIRE_RESISTANCE_ENABLED = ConfigSettings.addSyncedSetting("fire_resistance_enabled", () -> true, holder -> holder.set(MainSettingsConfig.getInstance().isFireResistanceEnabled()), encoder -> ConfigHelper.serializeNbtBool(encoder, "FireResistanceEnabled"), decoder -> decoder.m_128471_("FireResistanceEnabled"), saver -> MainSettingsConfig.getInstance().setFireResistanceEnabled((boolean)saver));
    public static final DynamicHolder<Boolean> ICE_RESISTANCE_ENABLED = ConfigSettings.addSyncedSetting("ice_resistance_enabled", () -> true, holder -> holder.set(MainSettingsConfig.getInstance().isIceResistanceEnabled()), encoder -> ConfigHelper.serializeNbtBool(encoder, "IceResistanceEnabled"), decoder -> decoder.m_128471_("IceResistanceEnabled"), saver -> MainSettingsConfig.getInstance().setIceResistanceEnabled((boolean)saver));
    public static final DynamicHolder<Boolean> USE_PEACEFUL_MODE = ConfigSettings.addSyncedSetting("use_peaceful", () -> true, holder -> holder.set(MainSettingsConfig.getInstance().nullifyInPeaceful()), encoder -> ConfigHelper.serializeNbtBool(encoder, "UsePeaceful"), decoder -> decoder.m_128471_("UsePeaceful"), saver -> MainSettingsConfig.getInstance().setNullifyInPeaceful((boolean)saver));
    public static final DynamicHolder<Boolean> REQUIRE_THERMOMETER = ConfigSettings.addSyncedSetting("require_thermometer", () -> true, holder -> holder.set(MainSettingsConfig.getInstance().thermometerRequired()), encoder -> ConfigHelper.serializeNbtBool(encoder, "RequireThermometer"), decoder -> decoder.m_128471_("RequireThermometer"), saver -> MainSettingsConfig.getInstance().setRequireThermometer((boolean)saver));
    public static final DynamicHolder<Integer> GRACE_LENGTH = ConfigSettings.addSyncedSetting("grace_length", () -> 6000, holder -> holder.set(MainSettingsConfig.getInstance().getGracePeriodLength()), encoder -> ConfigHelper.serializeNbtInt(encoder, "GraceLength"), decoder -> decoder.m_128451_("GraceLength"), saver -> MainSettingsConfig.getInstance().setGracePeriodLength((int)saver));
    public static final DynamicHolder<Boolean> GRACE_ENABLED = ConfigSettings.addSyncedSetting("grace_enabled", () -> true, holder -> holder.set(MainSettingsConfig.getInstance().isGracePeriodEnabled()), encoder -> ConfigHelper.serializeNbtBool(encoder, "GraceEnabled"), decoder -> decoder.m_128471_("GraceEnabled"), saver -> MainSettingsConfig.getInstance().setGracePeriodEnabled((boolean)saver));
    public static final DynamicHolder<Double> HEARTS_FREEZING_PERCENTAGE = ConfigSettings.addSyncedSetting("hearts_freezing_percentage", () -> 0.5, holder -> holder.set(MainSettingsConfig.getInstance().getHeartsFreezingPercentage()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "HeartsFreezingPercentage"), decoder -> decoder.m_128459_("HeartsFreezingPercentage"), saver -> MainSettingsConfig.getInstance().setHeartsFreezingPercentage((double)saver));
    public static final DynamicHolder<Double> COLD_MINING_IMPAIRMENT = ConfigSettings.addSyncedSetting("cold_mining_slowdown", () -> 0.5, holder -> holder.set(MainSettingsConfig.getInstance().getColdMiningImpairment()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "ColdMiningImpairment"), decoder -> decoder.m_128459_("ColdMiningImpairment"), saver -> MainSettingsConfig.getInstance().setColdMiningImpairment((double)saver));
    public static final DynamicHolder<Double> COLD_MOVEMENT_SLOWDOWN = ConfigSettings.addSyncedSetting("cold_movement_slowdown", () -> 0.5, holder -> holder.set(MainSettingsConfig.getInstance().getColdMovementSlowdown()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "ColdMovementSlowdown"), decoder -> decoder.m_128459_("ColdMovementSlowdown"), saver -> MainSettingsConfig.getInstance().setColdMovementSlowdown((double)saver));
    public static final DynamicHolder<Double> COLD_KNOCKBACK_REDUCTION = ConfigSettings.addSyncedSetting("cold_knockback_reduction", () -> 0.5, holder -> holder.set(MainSettingsConfig.getInstance().getColdKnockbackReduction()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "ColdKnockbackReduction"), decoder -> decoder.m_128459_("ColdKnockbackReduction"), saver -> MainSettingsConfig.getInstance().setColdKnockbackReduction((double)saver));
    public static final DynamicHolder<Double> HEATSTROKE_FOG_DISTANCE = ConfigSettings.addSyncedSetting("heatstroke_fog_distance", () -> 6.0, holder -> holder.set(MainSettingsConfig.getInstance().getHeatstrokeFogDistance()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "HeatstrokeFogDistance"), decoder -> decoder.m_128459_("HeatstrokeFogDistance"), saver -> MainSettingsConfig.getInstance().setHeatstrokeFogDistance((double)saver));
    public static final DynamicHolder<Map<Biome, Triplet<Double, Double, Temperature.Units>>> BIOME_TEMPS = ConfigSettings.addSyncedSettingWithRegistries("biome_temps", FastMap::new, (holder, registryAccess) -> ((Map)holder.get(registryAccess)).putAll(ConfigHelper.getBiomesWithValues(WorldSettingsConfig.getInstance().getBiomeTemperatures(), true, registryAccess)), (encoder, registryAccess) -> ConfigHelper.serializeBiomeTemps(encoder, "BiomeTemps", registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeBiomeTemps(decoder, "BiomeTemps", registryAccess), (saver, registryAccess) -> WorldSettingsConfig.getInstance().setBiomeTemperatures(saver.entrySet().stream().map(entry -> {
        ResourceLocation biome = RegistryHelper.getBiomeId((Biome)entry.getKey(), registryAccess);
        if (biome == null) {
            return null;
        }
        Temperature.Units units = (Temperature.Units)((Object)((Object)((Object)((Triplet)entry.getValue()).getC())));
        double min = Temperature.convert((Double)((Triplet)entry.getValue()).getA(), Temperature.Units.MC, units, true);
        double max = Temperature.convert((Double)((Triplet)entry.getValue()).getB(), Temperature.Units.MC, units, true);
        return Arrays.asList(biome.toString(), min, max, units.toString());
    }).filter(Objects::nonNull).collect(Collectors.toList())));
    public static final DynamicHolder<Map<Biome, Triplet<Double, Double, Temperature.Units>>> BIOME_OFFSETS = ConfigSettings.addSyncedSettingWithRegistries("biome_offsets", FastMap::new, (holder, registryAccess) -> ((Map)holder.get(registryAccess)).putAll(ConfigHelper.getBiomesWithValues(WorldSettingsConfig.getInstance().getBiomeTempOffsets(), false, registryAccess)), (encoder, registryAccess) -> ConfigHelper.serializeBiomeTemps(encoder, "BiomeOffsets", registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeBiomeTemps(decoder, "BiomeOffsets", registryAccess), (saver, registryAccess) -> WorldSettingsConfig.getInstance().setBiomeTempOffsets(saver.entrySet().stream().map(entry -> {
        ResourceLocation biome = RegistryHelper.getBiomeId((Biome)entry.getKey(), registryAccess);
        if (biome == null) {
            return null;
        }
        Temperature.Units units = (Temperature.Units)((Object)((Object)((Object)((Triplet)entry.getValue()).getC())));
        double min = Temperature.convert((Double)((Triplet)entry.getValue()).getA(), Temperature.Units.MC, units, false);
        double max = Temperature.convert((Double)((Triplet)entry.getValue()).getB(), Temperature.Units.MC, units, false);
        return Arrays.asList(biome.toString(), min, max, units.toString());
    }).filter(Objects::nonNull).collect(Collectors.toList())));
    public static final DynamicHolder<Map<DimensionType, Pair<Double, Temperature.Units>>> DIMENSION_TEMPS = ConfigSettings.addSyncedSettingWithRegistries("dimension_temps", FastMap::new, (holder, registryAccess) -> ((Map)holder.get(registryAccess)).putAll(ConfigHelper.getDimensionsWithValues(WorldSettingsConfig.getInstance().getDimensionTemperatures(), true, registryAccess)), (encoder, registryAccess) -> ConfigHelper.serializeDimensionTemps(encoder, "DimensionTemps", registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeDimensionTemps(decoder, "DimensionTemps", registryAccess), (saver, registryAccess) -> WorldSettingsConfig.getInstance().setDimensionTemperatures(saver.entrySet().stream().map(entry -> {
        ResourceLocation dim = RegistryHelper.getDimensionId((DimensionType)entry.getKey(), registryAccess);
        if (dim == null) {
            return null;
        }
        Temperature.Units units = (Temperature.Units)((Object)((Object)((Object)((Pair)entry.getValue()).getSecond())));
        double temp = Temperature.convert((Double)((Pair)entry.getValue()).getFirst(), Temperature.Units.MC, units, true);
        return Arrays.asList(dim.toString(), temp, units.toString());
    }).filter(Objects::nonNull).collect(Collectors.toList())));
    public static final DynamicHolder<Map<DimensionType, Pair<Double, Temperature.Units>>> DIMENSION_OFFSETS = ConfigSettings.addSyncedSettingWithRegistries("dimension_offsets", FastMap::new, (holder, registryAccess) -> ((Map)holder.get(registryAccess)).putAll(ConfigHelper.getDimensionsWithValues(WorldSettingsConfig.getInstance().getDimensionTempOffsets(), false, registryAccess)), (encoder, registryAccess) -> ConfigHelper.serializeDimensionTemps(encoder, "DimensionOffsets", registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeDimensionTemps(decoder, "DimensionOffsets", registryAccess), (saver, registryAccess) -> WorldSettingsConfig.getInstance().setDimensionTempOffsets(saver.entrySet().stream().map(entry -> {
        ResourceLocation dim = RegistryHelper.getDimensionId((DimensionType)entry.getKey(), registryAccess);
        if (dim == null) {
            return null;
        }
        Temperature.Units units = (Temperature.Units)((Object)((Object)((Object)((Pair)entry.getValue()).getSecond())));
        double temp = Temperature.convert((Double)((Pair)entry.getValue()).getFirst(), Temperature.Units.MC, units, false);
        return Arrays.asList(dim.toString(), temp, units.toString());
    }).filter(Objects::nonNull).collect(Collectors.toList())));
    public static final DynamicHolder<Map<StructureType<?>, Pair<Double, Temperature.Units>>> STRUCTURE_TEMPS = ConfigSettings.addSyncedSettingWithRegistries("structure_temperatures", FastMap::new, (holder, registryAccess) -> ((Map)holder.get(registryAccess)).putAll(ConfigHelper.getStructuresWithValues(WorldSettingsConfig.getInstance().getStructureTemperatures(), true, registryAccess)), (encoder, registryAccess) -> ConfigHelper.serializeStructureTemps(encoder, "StructureTemperatures", registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeStructureTemps(decoder, "StructureTemperatures", registryAccess), (saver, registryAccess) -> WorldSettingsConfig.getInstance().setStructureTemperatures(saver.entrySet().stream().map(entry -> {
        ResourceLocation struct = RegistryHelper.getStructureId((StructureType)entry.getKey(), registryAccess);
        if (struct == null) {
            return null;
        }
        Temperature.Units units = (Temperature.Units)((Object)((Object)((Object)((Pair)entry.getValue()).getSecond())));
        double temp = Temperature.convert((Double)((Pair)entry.getValue()).getFirst(), Temperature.Units.MC, units, true);
        return Arrays.asList(struct.toString(), temp, units.toString());
    }).filter(Objects::nonNull).collect(Collectors.toList())));
    public static final DynamicHolder<Map<StructureType<?>, Pair<Double, Temperature.Units>>> STRUCTURE_OFFSETS = ConfigSettings.addSyncedSettingWithRegistries("structure_offsets", FastMap::new, (holder, registryAccess) -> ((Map)holder.get(registryAccess)).putAll(ConfigHelper.getStructuresWithValues(WorldSettingsConfig.getInstance().getStructureTempOffsets(), false, registryAccess)), (encoder, registryAccess) -> ConfigHelper.serializeStructureTemps(encoder, "StructureOffsets", registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeStructureTemps(decoder, "StructureOffsets", registryAccess), (saver, registryAccess) -> WorldSettingsConfig.getInstance().setStructureTempOffsets(saver.entrySet().stream().map(entry -> {
        ResourceLocation struct = RegistryHelper.getStructureId((StructureType)entry.getKey(), registryAccess);
        if (struct == null) {
            return null;
        }
        Temperature.Units units = (Temperature.Units)((Object)((Object)((Object)((Pair)entry.getValue()).getSecond())));
        double temp = Temperature.convert((Double)((Pair)entry.getValue()).getFirst(), Temperature.Units.MC, units, false);
        return Arrays.asList(struct.toString(), temp, units.toString());
    }).filter(Objects::nonNull).collect(Collectors.toList())));
    public static final DynamicHolder<List<DepthTempData>> DEPTH_REGIONS = ConfigSettings.addSetting("depth_regions", ArrayList::new, holder -> {});
    public static final DynamicHolder<Boolean> CHECK_SLEEP_CONDITIONS;
    public static final DynamicHolder<Double[]> SUMMER_TEMPS;
    public static final DynamicHolder<Double[]> AUTUMN_TEMPS;
    public static final DynamicHolder<Double[]> WINTER_TEMPS;
    public static final DynamicHolder<Double[]> SPRING_TEMPS;
    public static final DynamicHolder<Integer> BLOCK_RANGE;
    public static final DynamicHolder<Boolean> COLD_SOUL_FIRE;
    public static final DynamicHolder<List<Block>> HEARTH_SPREAD_WHITELIST;
    public static final DynamicHolder<List<Block>> HEARTH_SPREAD_BLACKLIST;
    public static final DynamicHolder<Double> HEARTH_STRENGTH;
    public static final DynamicHolder<Boolean> SMART_HEARTH;
    public static final DynamicHolder<List<Block>> SLEEP_CHECK_IGNORE_BLOCKS;
    public static final DynamicHolder<Boolean> USE_CUSTOM_WATER_FREEZE_BEHAVIOR;
    public static final DynamicHolder<Boolean> USE_CUSTOM_ICE_DROPS;
    public static final DynamicHolder<Multimap<Item, Insulator>> INSULATION_ITEMS;
    public static final DynamicHolder<Multimap<Item, Insulator>> INSULATING_ARMORS;
    public static final DynamicHolder<Multimap<Item, Insulator>> INSULATING_CURIOS;
    public static final DynamicHolder<ScalingFormula> INSULATION_SLOTS;
    public static final DynamicHolder<List<Item>> INSULATION_BLACKLIST;
    public static final DynamicHolder<Multimap<Item, PredicateItem>> FOOD_TEMPERATURES;
    public static final DynamicHolder<Multimap<Item, CarriedItemTemperature>> CARRIED_ITEM_TEMPERATURES;
    public static final DynamicHolder<Integer> WATERSKIN_STRENGTH;
    public static final DynamicHolder<Double> SOULSPRING_LAMP_STRENGTH;
    public static final DynamicHolder<List<DimensionType>> LAMP_DIMENSIONS;
    public static final DynamicHolder<Multimap<Item, PredicateItem>> BOILER_FUEL;
    public static final DynamicHolder<Multimap<Item, PredicateItem>> ICEBOX_FUEL;
    public static final DynamicHolder<Multimap<Item, PredicateItem>> HEARTH_FUEL;
    public static final DynamicHolder<Multimap<Item, PredicateItem>> SOULSPRING_LAMP_FUEL;
    public static final DynamicHolder<Boolean> HEARTH_POTIONS_ENABLED;
    public static final DynamicHolder<List<MobEffect>> HEARTH_POTION_BLACKLIST;
    public static final DynamicHolder<Triplet<Integer, Integer, Double>> FUR_TIMINGS;
    public static final DynamicHolder<Triplet<Integer, Integer, Double>> SHED_TIMINGS;
    public static final DynamicHolder<Multimap<Biome, SpawnBiomeData>> ENTITY_SPAWN_BIOMES;
    public static final DynamicHolder<Multimap<EntityType<?>, InsulatingMount>> INSULATED_ENTITIES;
    public static final DynamicHolder<Multimap<EntityType<?>, EntityTempData>> ENTITY_TEMPERATURES;
    public static final DynamicHolder<Double> INSULATION_STRENGTH;
    public static final DynamicHolder<List<ResourceLocation>> DISABLED_MODIFIERS;
    public static final DynamicHolder<Boolean> CELSIUS;
    public static final DynamicHolder<Integer> TEMP_OFFSET;
    public static final DynamicHolder<Double> TEMP_SMOOTHING;
    public static final DynamicHolder<Vec2i> BODY_ICON_POS;
    public static final DynamicHolder<Boolean> BODY_ICON_ENABLED;
    public static final DynamicHolder<Boolean> MOVE_BODY_ICON_WHEN_ADVANCED;
    public static final DynamicHolder<Vec2i> BODY_READOUT_POS;
    public static final DynamicHolder<Boolean> BODY_READOUT_ENABLED;
    public static final DynamicHolder<Vec2i> WORLD_GAUGE_POS;
    public static final DynamicHolder<Boolean> WORLD_GAUGE_ENABLED;
    public static final DynamicHolder<Boolean> CUSTOM_HOTBAR_LAYOUT;
    public static final DynamicHolder<Boolean> ICON_BOBBING;
    public static final DynamicHolder<Boolean> HEARTH_DEBUG;
    public static final DynamicHolder<Boolean> SHOW_CONFIG_BUTTON;
    public static final DynamicHolder<Vec2i> CONFIG_BUTTON_POS;
    public static final DynamicHolder<Boolean> DISTORTION_EFFECTS;
    public static final DynamicHolder<Boolean> HIGH_CONTRAST;
    public static final DynamicHolder<Boolean> SHOW_CREATIVE_WARNING;
    public static final DynamicHolder<Boolean> HIDE_TOOLTIPS;
    public static final DynamicHolder<Boolean> EXPAND_TOOLTIPS;
    public static final DynamicHolder<Boolean> SHOW_WATER_EFFECT;

    public static String getKey(DynamicHolder<?> setting) {
        return (String)CONFIG_SETTINGS.inverse().get(setting);
    }

    public static DynamicHolder<?> getSetting(String key) {
        return (DynamicHolder)CONFIG_SETTINGS.get((Object)key);
    }

    public static <T> DynamicHolder<T> addSetting(String id, Supplier<T> defaultVal, Consumer<DynamicHolder<T>> loader) {
        DynamicHolder<T> holder = DynamicHolder.create(defaultVal, loader);
        CONFIG_SETTINGS.put((Object)id, holder);
        return holder;
    }

    public static <T> DynamicHolder<T> addSettingWithRegistries(String id, Supplier<T> defaultVal, DynamicHolder.Loader<T> loader) {
        DynamicHolder<T> holder = DynamicHolder.createWithRegistries(defaultVal, loader);
        CONFIG_SETTINGS.put((Object)id, holder);
        return holder;
    }

    public static <T> DynamicHolder<T> addSyncedSetting(String id, Supplier<T> defaultVal, Consumer<DynamicHolder<T>> loader, Function<T, CompoundTag> writer, Function<CompoundTag, T> reader, Consumer<T> saver) {
        DynamicHolder<T> holder = DynamicHolder.createSynced(defaultVal, loader, writer, reader, saver);
        CONFIG_SETTINGS.put((Object)id, holder);
        return holder;
    }

    public static <T> DynamicHolder<T> addSyncedSettingWithRegistries(String id, Supplier<T> defaultVal, DynamicHolder.Loader<T> loader, DynamicHolder.Writer<T> writer, DynamicHolder.Reader<T> reader, DynamicHolder.Saver<T> saver) {
        DynamicHolder<T> holder = DynamicHolder.createSyncedWithRegistries(defaultVal, loader, writer, reader, saver);
        CONFIG_SETTINGS.put((Object)id, holder);
        return holder;
    }

    public static <T> DynamicHolder<T> addClientSetting(String id, Supplier<T> defaultVal, Consumer<DynamicHolder<T>> loader) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            DynamicHolder<T> holder = DynamicHolder.create(defaultVal, loader);
            CLIENT_SETTINGS.put((Object)id, holder);
            return holder;
        }
        return DynamicHolder.create(() -> null, value -> {});
    }

    public static Map<String, CompoundTag> encode(RegistryAccess registryAccess) {
        HashMap<String, CompoundTag> map = new HashMap<String, CompoundTag>();
        CONFIG_SETTINGS.forEach((key, value) -> {
            if (value.isSynced()) {
                map.put((String)key, value.encode(registryAccess));
            }
        });
        return map;
    }

    public static void decode(String key, CompoundTag tag, RegistryAccess registryAccess) {
        CONFIG_SETTINGS.computeIfPresent((Object)key, (k, value) -> {
            value.decode(tag, registryAccess);
            return value;
        });
    }

    public static void saveValues(RegistryAccess registryAccess) {
        CONFIG_SETTINGS.values().forEach(value -> {
            if (value.isSynced()) {
                value.save(registryAccess);
            }
        });
    }

    public static void load(RegistryAccess registryAccess, boolean replace) {
        if (registryAccess != null) {
            CONFIG_SETTINGS.values().forEach(dynamicHolder -> dynamicHolder.load(registryAccess, replace));
        } else {
            ColdSweat.LOGGER.warn("Loading Cold Sweat config settings without registry access. This is normal during startup.");
            CONFIG_SETTINGS.values().forEach(dynamicHolder -> {
                if (!dynamicHolder.requiresRegistries()) {
                    dynamicHolder.load(replace);
                }
            });
        }
    }

    public static void clear() {
        for (Map.Entry entry : CONFIG_SETTINGS.entrySet()) {
            ((DynamicHolder)entry.getValue()).reset();
        }
    }

    private static /* synthetic */ void lambda$static$190(RegistryAccess registryAccess, Multimap map, List configBiomes, EntityType entityType) {
        for (List entry : configBiomes) {
            Either biomeEither;
            String biomeId = (String)entry.get(0);
            List<Biome> biomes = ConfigHelper.parseRegistryItems(Registry.f_122885_, registryAccess, biomeId);
            if (biomeId.charAt(0) == '#') {
                biomeEither = Either.left((Object)TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(biomeId.substring(1))));
            } else {
                Biome biome = RegistryHelper.getBiome(new ResourceLocation(biomeId), registryAccess);
                if (biome == null) continue;
                biomeEither = Either.right((Object)biome);
            }
            for (Biome biome : biomes) {
                SpawnBiomeData spawnData = new SpawnBiomeData(List.of(biomeEither), MobCategory.CREATURE, ((Number)entry.get(1)).intValue(), List.of(Either.right((Object)entityType)), Optional.empty());
                map.put((Object)biome, (Object)spawnData);
            }
        }
    }

    static {
        BiFunction<Item, List, PredicateItem> fuelMapper = (item, args) -> {
            double fuel = ((Number)args.get(0)).doubleValue();
            NbtRequirement nbtRequirement = args.size() > 2 ? new NbtRequirement(NBTHelper.parseCompoundNbt((String)args.get(2))) : new NbtRequirement(new CompoundTag());
            return new PredicateItem(fuel, new ItemRequirement(Optional.of(List.of(Either.right((Object)item))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), nbtRequirement), EntityRequirement.NONE);
        };
        BOILER_FUEL = ConfigSettings.addSetting("boiler_fuel_items", FastMultiMap::new, holder -> ((Multimap)holder.get()).putAll(ConfigHelper.readItemMultimap(ItemSettingsConfig.getInstance().getBoilerFuelItems(), fuelMapper)));
        ICEBOX_FUEL = ConfigSettings.addSetting("icebox_fuel_items", FastMultiMap::new, holder -> ((Multimap)holder.get()).putAll(ConfigHelper.readItemMultimap(ItemSettingsConfig.getInstance().getIceboxFuelItems(), fuelMapper)));
        HEARTH_FUEL = ConfigSettings.addSetting("hearth_fuel_items", FastMultiMap::new, holder -> ((Multimap)holder.get()).putAll(ConfigHelper.readItemMultimap(ItemSettingsConfig.getInstance().getHearthFuelItems(), fuelMapper)));
        SOULSPRING_LAMP_FUEL = ConfigSettings.addSyncedSetting("lamp_fuel_items", FastMultiMap::new, holder -> ((Multimap)holder.get()).putAll(ConfigHelper.readItemMultimap(ItemSettingsConfig.getInstance().getSoulLampFuelItems(), fuelMapper)), encoder -> ConfigHelper.serializeItemMultimap(encoder, "LampFuelItems", fuel -> fuel.serialize()), decoder -> ConfigHelper.deserializeItemMultimap(decoder, "LampFuelItems", nbt -> PredicateItem.deserialize(nbt)), saver -> ConfigHelper.writeItemMultimap(saver, list -> ItemSettingsConfig.getInstance().setSoulLampFuelItems((List<? extends List<?>>)list), fuel -> List.of(fuel.value(), fuel.data().nbt().tag().toString())));
        HEARTH_POTIONS_ENABLED = ConfigSettings.addSetting("hearth_potions_enabled", () -> true, holder -> holder.set(ItemSettingsConfig.getInstance().arePotionsEnabled()));
        HEARTH_POTION_BLACKLIST = ConfigSettings.addSetting("hearth_potion_blacklist", ArrayList::new, holder -> ((List)holder.get()).addAll(ItemSettingsConfig.getInstance().getPotionBlacklist().stream().map(entry -> (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(entry))).collect(ArrayList::new, List::add, List::addAll)));
        INSULATION_ITEMS = ConfigSettings.addSyncedSetting("insulation_items", FastMultiMap::new, holder -> ((Multimap)holder.get()).putAll(ConfigHelper.readItemInsulations(ItemSettingsConfig.getInstance().getInsulationItems(), Insulation.Slot.ITEM)), encoder -> ConfigHelper.serializeItemInsulations((Multimap<Item, Insulator>)encoder, "InsulationItems"), decoder -> ConfigHelper.deserializeItemInsulations(decoder, "InsulationItems"), saver -> ConfigHelper.writeItemInsulations((Multimap<Item, Insulator>)saver, list -> ItemSettingsConfig.getInstance().setInsulationItems((List<? extends List<?>>)list)));
        INSULATING_ARMORS = ConfigSettings.addSyncedSetting("insulating_armors", FastMultiMap::new, holder -> ((Multimap)holder.get()).putAll(ConfigHelper.readItemInsulations(ItemSettingsConfig.getInstance().getInsulatingArmorItems(), Insulation.Slot.ARMOR)), encoder -> ConfigHelper.serializeItemInsulations((Multimap<Item, Insulator>)encoder, "InsulatingArmors"), decoder -> ConfigHelper.deserializeItemInsulations(decoder, "InsulatingArmors"), saver -> ConfigHelper.writeItemInsulations((Multimap<Item, Insulator>)saver, list -> ItemSettingsConfig.getInstance().setInsulatingArmorItems((List<? extends List<?>>)list)));
        INSULATING_CURIOS = ConfigSettings.addSyncedSetting("insulating_curios", FastMultiMap::new, holder -> {
            if (CompatManager.isCuriosLoaded()) {
                ((Multimap)holder.get()).putAll(ConfigHelper.readItemInsulations(ItemSettingsConfig.getInstance().getInsulatingCurios(), Insulation.Slot.CURIO));
            }
        }, encoder -> ConfigHelper.serializeItemInsulations((Multimap<Item, Insulator>)encoder, "InsulatingCurios"), decoder -> ConfigHelper.deserializeItemInsulations(decoder, "InsulatingCurios"), saver -> {
            if (CompatManager.isCuriosLoaded()) {
                ConfigHelper.writeItemInsulations((Multimap<Item, Insulator>)saver, list -> ItemSettingsConfig.getInstance().setInsulatingCurios((List<? extends List<?>>)list));
            }
        });
        INSULATION_SLOTS = ConfigSettings.addSyncedSetting("insulation_slots", () -> new ScalingFormula.Static(0, 0, 0, 0), holder -> {
            List<Object> list = ItemSettingsConfig.getInstance().getArmorInsulationSlots();
            if (list.size() == 4 && list.stream().allMatch(el -> el instanceof Integer)) {
                list = List.of("static", list.get(0), list.get(1), list.get(2), list.get(3));
            }
            String mode = (String)list.get(0);
            ScalingFormula.Type scalingType = ScalingFormula.Type.byName(mode);
            List<Number> values = list.subList(1, list.size()).stream().map(o -> (Number)o).toList();
            holder.set(scalingType == ScalingFormula.Type.STATIC ? new ScalingFormula.Static(values.get(0).intValue(), values.get(1).intValue(), values.get(2).intValue(), values.get(3).intValue()) : new ScalingFormula.Dynamic(scalingType, values.get(0).doubleValue(), values.size() > 2 ? values.get(2).doubleValue() : Double.MAX_VALUE));
        }, encoder -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Mode", encoder.getType().m_7912_());
            ListTag values = new ListTag();
            encoder.getValues().forEach(value -> values.add((Object)DoubleTag.m_128500_((double)value.doubleValue())));
            tag.m_128365_("Values", (Tag)values);
            return tag;
        }, decoder -> {
            ScalingFormula.Type scalingType = ScalingFormula.Type.byName(decoder.m_128461_("Mode"));
            List<Number> values = decoder.m_128437_("Values", 6).stream().map(tag -> ((DoubleTag)tag).m_8103_()).toList();
            return scalingType == ScalingFormula.Type.STATIC ? new ScalingFormula.Static(values.get(0).intValue(), values.get(1).intValue(), values.get(2).intValue(), values.get(3).intValue()) : new ScalingFormula.Dynamic(scalingType, values.get(0).doubleValue(), values.size() > 2 ? values.get(2).doubleValue() : Double.MAX_VALUE);
        }, saver -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(saver.getType().m_7912_());
            list.addAll(saver.getValues());
            ItemSettingsConfig.getInstance().setArmorInsulationSlots(list);
        });
        INSULATION_BLACKLIST = ConfigSettings.addSetting("insulation_blacklist", ArrayList::new, holder -> ((List)holder.get()).addAll(ItemSettingsConfig.getInstance().getInsulationBlacklist().stream().map(entry -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry))).collect(ArrayList::new, List::add, List::addAll)));
        CHECK_SLEEP_CONDITIONS = ConfigSettings.addSetting("check_sleep_conditions", () -> true, holder -> holder.set(WorldSettingsConfig.getInstance().isSleepChecked()));
        SLEEP_CHECK_IGNORE_BLOCKS = ConfigSettings.addSetting("sleep_check_override_blocks", ArrayList::new, holder -> ((List)holder.get()).addAll(ConfigHelper.getBlocks(WorldSettingsConfig.getInstance().getSleepOverrideBlocks().toArray(new String[0]))));
        USE_CUSTOM_WATER_FREEZE_BEHAVIOR = ConfigSettings.addSetting("custom_freeze_check", () -> true, holder -> holder.set((Boolean)WorldSettingsConfig.CUSTOM_WATER_FREEZE_BEHAVIOR.get()));
        USE_CUSTOM_ICE_DROPS = ConfigSettings.addSetting("custom_ice_drops", () -> true, holder -> holder.set((Boolean)WorldSettingsConfig.CUSTOM_ICE_DROPS.get()));
        FOOD_TEMPERATURES = ConfigSettings.addSyncedSetting("food_temperatures", FastMultiMap::new, holder -> ((Multimap)holder.get()).putAll(ConfigHelper.readItemMultimap(ItemSettingsConfig.getInstance().getFoodTemperatures(), (item, args) -> {
            double value = ((Number)args.get(0)).doubleValue();
            NbtRequirement nbtRequirement = args.size() > 1 ? new NbtRequirement(NBTHelper.parseCompoundNbt((String)args.get(1))) : new NbtRequirement(new CompoundTag());
            Integer duration = args.size() > 2 ? Integer.valueOf(((Number)args.get(2)).intValue()) : null;
            ItemRequirement itemRequirement = new ItemRequirement(Optional.of(List.of(Either.right((Object)item))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), nbtRequirement);
            CompoundTag tag = new CompoundTag();
            if (duration != null) {
                tag.m_128405_("duration", duration.intValue());
            }
            return new PredicateItem(value, itemRequirement, EntityRequirement.NONE, tag);
        })), encoder -> ConfigHelper.serializeItemMultimap(encoder, "FoodTemperatures", PredicateItem::serialize), decoder -> ConfigHelper.deserializeItemMultimap(decoder, "FoodTemperatures", PredicateItem::deserialize), saver -> ConfigHelper.writeItemMultimap(saver, list -> ItemSettingsConfig.getInstance().setFoodTemperatures((List<? extends List<?>>)list), food -> {
            ArrayList<String> foodData = new ArrayList<String>(List.of(food.value(), food.data().nbt().tag().toString()));
            if (food.extraData().m_128441_("duration")) {
                foodData.add((String)((Object)Integer.valueOf(food.extraData().m_128451_("duration"))));
            }
            return foodData;
        }));
        CARRIED_ITEM_TEMPERATURES = ConfigSettings.addSyncedSetting("carried_item_temps", FastMultiMap::new, holder -> {
            List<List<?>> list = ItemSettingsConfig.getInstance().getCarriedTemps();
            FastMultiMap map = new FastMultiMap();
            for (List<?> entry : list) {
                List<?> entryList = entry;
                String itemID = (String)entryList.get(0);
                Either item = itemID.startsWith("#") ? Either.left((Object)TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(itemID.substring(1)))) : Either.right((Object)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemID))));
                double temp = ((Number)entryList.get(1)).doubleValue();
                List<Either<IntegerBounds, EquipmentSlot>> slots = switch ((String)entryList.get(2)) {
                    case "inventory" -> List.of(Either.left((Object)IntegerBounds.NONE));
                    case "hotbar" -> List.of(Either.left((Object)new IntegerBounds(36, 44)));
                    case "hand" -> List.of(Either.right((Object)EquipmentSlot.MAINHAND), Either.right((Object)EquipmentSlot.OFFHAND));
                    default -> List.of(Either.left((Object)new IntegerBounds(-1, -1)));
                };
                Temperature.Trait trait = Temperature.Trait.fromID((String)entryList.get(3));
                NbtRequirement nbtRequirement = entryList.size() > 4 ? new NbtRequirement(NBTHelper.parseCompoundNbt((String)entryList.get(4))) : new NbtRequirement(new CompoundTag());
                double maxEffect = entryList.size() > 5 ? ((Number)entryList.get(5)).doubleValue() : Double.MAX_VALUE;
                ItemRequirement itemRequirement = new ItemRequirement(Optional.of(List.of(item)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), nbtRequirement);
                CarriedItemTemperature carriedTemp = new CarriedItemTemperature(itemRequirement, slots, temp, trait, maxEffect, EntityRequirement.NONE);
                if (item.left().isPresent()) {
                    ForgeRegistries.ITEMS.tags().getTag((TagKey)item.left().get()).stream().forEach(i -> map.put(i, carriedTemp));
                    continue;
                }
                map.put((Item)item.right().get(), carriedTemp);
            }
            ((Multimap)holder.get()).putAll(map);
        }, encoder -> ConfigHelper.serializeItemMultimap(encoder, "CarriedItemTemps", CarriedItemTemperature::serialize), decoder -> ConfigHelper.deserializeItemMultimap(decoder, "CarriedItemTemps", CarriedItemTemperature::deserialize), saver -> ConfigHelper.writeItemMultimap(saver, list -> ItemSettingsConfig.getInstance().setCarriedTemps((List<? extends List<?>>)list), temp -> {
            ArrayList<Object> entry = new ArrayList<Object>();
            entry.add(temp.temperature());
            String strictType = temp.getSlotRangeName();
            if (strictType.isEmpty()) {
                return null;
            }
            entry.add(strictType);
            entry.add(temp.trait().m_7912_());
            if (!temp.item().nbt().tag().m_128456_()) {
                entry.add(temp.item().nbt().tag().toString());
            }
            return entry;
        }));
        WATERSKIN_STRENGTH = ConfigSettings.addSetting("waterskin_strength", () -> 50, holder -> holder.set(ItemSettingsConfig.getInstance().getWaterskinStrength()));
        SOULSPRING_LAMP_STRENGTH = ConfigSettings.addSetting("soulspring_lamp_strength", () -> 0.6, holder -> holder.set((Double)ItemSettingsConfig.SOULSPRING_LAMP_STRENGTH.get()));
        LAMP_DIMENSIONS = ConfigSettings.addSettingWithRegistries("valid_lamp_dimensions", ArrayList::new, (holder, registryAccess) -> ((List)holder.get(registryAccess)).addAll(new ArrayList(ItemSettingsConfig.getInstance().getValidSoulLampDimensions().stream().map(entry -> (DimensionType)registryAccess.m_175515_(Registry.f_122818_).m_7745_(new ResourceLocation(entry))).collect(ArrayList::new, List::add, List::addAll))));
        FUR_TIMINGS = ConfigSettings.addSyncedSetting("fur_timings", () -> new Triplet((Object)0, (Object)0, (Object)0.0), holder -> {
            List<?> entry = EntitySettingsConfig.getInstance().getGoatFurStats();
            holder.set(new Triplet((Object)((Number)entry.get(0)).intValue(), (Object)((Number)entry.get(1)).intValue(), (Object)((Number)entry.get(2)).doubleValue()));
        }, encoder -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Interval", (Tag)IntTag.m_128679_((int)((Integer)encoder.getA())));
            tag.m_128365_("Cooldown", (Tag)IntTag.m_128679_((int)((Integer)encoder.getB())));
            tag.m_128365_("Chance", (Tag)DoubleTag.m_128500_((double)((Double)encoder.getC())));
            return tag;
        }, decoder -> {
            int interval = decoder.m_128451_("Interval");
            int cooldown = decoder.m_128451_("Cooldown");
            double chance = decoder.m_128459_("Chance");
            return new Triplet((Object)interval, (Object)cooldown, (Object)chance);
        }, saver -> {
            ArrayList<Number> list = new ArrayList<Number>();
            list.add((Number)saver.getA());
            list.add((Number)saver.getB());
            list.add((Number)saver.getC());
            EntitySettingsConfig.getInstance().setGoatFurStats(list);
        });
        SHED_TIMINGS = ConfigSettings.addSyncedSetting("shed_timings", () -> new Triplet((Object)0, (Object)0, (Object)0.0), holder -> {
            List<?> entry = EntitySettingsConfig.getInstance().getChameleonShedStats();
            holder.set(new Triplet((Object)((Number)entry.get(0)).intValue(), (Object)((Number)entry.get(1)).intValue(), (Object)((Number)entry.get(2)).doubleValue()));
        }, encoder -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Interval", (Tag)IntTag.m_128679_((int)((Integer)encoder.getA())));
            tag.m_128365_("Cooldown", (Tag)IntTag.m_128679_((int)((Integer)encoder.getB())));
            tag.m_128365_("Chance", (Tag)DoubleTag.m_128500_((double)((Double)encoder.getC())));
            return tag;
        }, decoder -> {
            int interval = decoder.m_128451_("Interval");
            int cooldown = decoder.m_128451_("Cooldown");
            double chance = decoder.m_128459_("Chance");
            return new Triplet((Object)interval, (Object)cooldown, (Object)chance);
        }, saver -> {
            ArrayList<Number> list = new ArrayList<Number>();
            list.add((Number)saver.getA());
            list.add((Number)saver.getB());
            list.add((Number)saver.getC());
            EntitySettingsConfig.getInstance().setChameleonShedStats(list);
        });
        ENTITY_SPAWN_BIOMES = ConfigSettings.addSettingWithRegistries("entity_spawn_biomes", FastMultiMap::new, (holder, registryAccess) -> {
            HashMultimap map = HashMultimap.create();
            BiConsumer<List, EntityType> configReader = (arg_0, arg_1) -> ConfigSettings.lambda$static$190(registryAccess, (Multimap)map, arg_0, arg_1);
            configReader.accept(EntitySettingsConfig.getInstance().getChameleonSpawnBiomes(), ModEntities.CHAMELEON);
            configReader.accept(EntitySettingsConfig.getInstance().getGoatSpawnBiomes(), EntityType.f_147035_);
            ((Multimap)holder.get(registryAccess)).putAll((Multimap)map);
        });
        INSULATED_ENTITIES = ConfigSettings.addSetting("insulated_entities", FastMultiMap::new, holder -> ((Multimap)holder.get()).putAll((Multimap)EntitySettingsConfig.getInstance().getInsulatedEntities().stream().map(entry -> {
            ArrayList entries = new ArrayList();
            String entityID = (String)entry.get(0);
            double coldInsul = ((Number)entry.get(1)).doubleValue();
            double hotInsul = entry.size() < 3 ? coldInsul : ((Number)entry.get(2)).doubleValue();
            for (EntityType<?> entityType : ConfigHelper.getEntityTypes(entityID)) {
                entries.add(Map.entry(entityType, new InsulatingMount(entityType, coldInsul, hotInsul, EntityRequirement.NONE)));
            }
            return entries;
        }).flatMap(Collection::stream).distinct().filter(entry -> entry.getKey() != null).collect(FastMultiMap::new, (map, entry) -> map.put((EntityType)entry.getKey(), (InsulatingMount)entry.getValue()), FastMultiMap::putAll)));
        ENTITY_TEMPERATURES = ConfigSettings.addSetting("entity_temperatures", FastMultiMap::new, holder -> {
            List list = (List)EntitySettingsConfig.ENTITY_TEMPERATURES.get();
            FastMultiMap map = new FastMultiMap();
            for (Object entry : list) {
                List entryList = (List)entry;
                String entityID = (String)entryList.get(0);
                double temp = ((Number)entryList.get(1)).doubleValue();
                double range = ((Number)entryList.get(2)).doubleValue();
                Temperature.Units units = entryList.size() > 3 ? Temperature.Units.fromID((String)entryList.get(3)) : Temperature.Units.MC;
                for (EntityType<?> entityType : ConfigHelper.getEntityTypes(entityID)) {
                    EntityRequirement requirement = new EntityRequirement(Optional.of(entityType), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
                    map.put(entityType, new EntityTempData(requirement, temp, range, units, Optional.empty(), Optional.empty()));
                }
            }
            ((Multimap)holder.get()).putAll(map);
        });
        BLOCK_RANGE = ConfigSettings.addSyncedSetting("block_range", () -> 7, holder -> holder.set(WorldSettingsConfig.getInstance().getBlockRange()), encoder -> ConfigHelper.serializeNbtInt(encoder, "BlockRange"), decoder -> decoder.m_128451_("BlockRange"), saver -> WorldSettingsConfig.getInstance().setBlockRange((int)saver));
        COLD_SOUL_FIRE = ConfigSettings.addSetting("cold_soul_fire", () -> true, holder -> holder.set(WorldSettingsConfig.getInstance().isSoulFireCold()));
        HEARTH_SPREAD_WHITELIST = ConfigSettings.addSyncedSetting("hearth_spread_whitelist", ArrayList::new, holder -> ((List)holder.get()).addAll(ConfigHelper.getBlocks(WorldSettingsConfig.getInstance().getHearthSpreadWhitelist().toArray(new String[0]))), encoder -> {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (Block entry : encoder) {
                list.add((Object)StringTag.m_129297_((String)ForgeRegistries.BLOCKS.getKey((Object)entry).toString()));
            }
            tag.m_128365_("HearthWhitelist", (Tag)list);
            return tag;
        }, decoder -> {
            ArrayList<Block> list = new ArrayList<Block>();
            for (Tag entry : decoder.m_128437_("HearthWhitelist", 8)) {
                list.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.m_7916_())));
            }
            return list;
        }, saver -> WorldSettingsConfig.getInstance().setHearthSpreadWhitelist(saver.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getKey(arg_0)).toList()));
        HEARTH_SPREAD_BLACKLIST = ConfigSettings.addSyncedSetting("hearth_spread_blacklist", ArrayList::new, holder -> ((List)holder.get()).addAll(ConfigHelper.getBlocks(WorldSettingsConfig.getInstance().getHearthSpreadBlacklist().toArray(new String[0]))), encoder -> {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (Block entry : encoder) {
                list.add((Object)StringTag.m_129297_((String)ForgeRegistries.BLOCKS.getKey((Object)entry).toString()));
            }
            tag.m_128365_("HearthBlacklist", (Tag)list);
            return tag;
        }, decoder -> {
            ArrayList<Block> list = new ArrayList<Block>();
            for (Tag entry : decoder.m_128437_("HearthBlacklist", 8)) {
                list.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.m_7916_())));
            }
            return list;
        }, saver -> WorldSettingsConfig.getInstance().setHearthSpreadBlacklist(saver.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getKey(arg_0)).toList()));
        HEARTH_STRENGTH = ConfigSettings.addSetting("hearth_effect", () -> 0.75, holder -> holder.set(WorldSettingsConfig.getInstance().getHearthStrength()));
        SMART_HEARTH = ConfigSettings.addSetting("smart_hearth", () -> false, holder -> holder.set(WorldSettingsConfig.getInstance().isSmartHearth()));
        INSULATION_STRENGTH = ConfigSettings.addSetting("insulation_strength", () -> 1.0, holder -> holder.set(ItemSettingsConfig.getInstance().getInsulationStrength()));
        DISABLED_MODIFIERS = ConfigSettings.addSetting("disabled_modifiers", ArrayList::new, holder -> ((List)holder.get()).addAll(((List)MainSettingsConfig.DISABLED_TEMP_MODIFIERS.get()).stream().map(ResourceLocation::new).toList()));
        CELSIUS = ConfigSettings.addClientSetting("celsius", () -> false, holder -> holder.set(ClientSettingsConfig.getInstance().isCelsius()));
        TEMP_OFFSET = ConfigSettings.addClientSetting("temp_offset", () -> 0, holder -> holder.set(ClientSettingsConfig.getInstance().getTempOffset()));
        TEMP_SMOOTHING = ConfigSettings.addClientSetting("temp_smoothing", () -> 10.0, holder -> holder.set(ClientSettingsConfig.getInstance().getTempSmoothing()));
        BODY_ICON_POS = ConfigSettings.addClientSetting("body_icon_pos", Vec2i::new, holder -> holder.set(new Vec2i(ClientSettingsConfig.getInstance().getBodyIconX(), ClientSettingsConfig.getInstance().getBodyIconY())));
        BODY_ICON_ENABLED = ConfigSettings.addClientSetting("body_icon_enabled", () -> true, holder -> holder.set(ClientSettingsConfig.getInstance().isBodyIconEnabled()));
        MOVE_BODY_ICON_WHEN_ADVANCED = ConfigSettings.addClientSetting("move_body_icon_for_advanced", () -> true, holder -> holder.set(ClientSettingsConfig.getInstance().moveBodyIconWhenAdvanced()));
        BODY_READOUT_POS = ConfigSettings.addClientSetting("body_readout_pos", Vec2i::new, holder -> holder.set(new Vec2i(ClientSettingsConfig.getInstance().getBodyReadoutX(), ClientSettingsConfig.getInstance().getBodyReadoutY())));
        BODY_READOUT_ENABLED = ConfigSettings.addClientSetting("body_readout_enabled", () -> true, holder -> holder.set(ClientSettingsConfig.getInstance().isBodyReadoutEnabled()));
        WORLD_GAUGE_POS = ConfigSettings.addClientSetting("world_gauge_pos", Vec2i::new, holder -> holder.set(new Vec2i(ClientSettingsConfig.getInstance().getWorldGaugeX(), ClientSettingsConfig.getInstance().getWorldGaugeY())));
        WORLD_GAUGE_ENABLED = ConfigSettings.addClientSetting("world_gauge_enabled", () -> true, holder -> holder.set(ClientSettingsConfig.getInstance().isWorldGaugeEnabled()));
        CUSTOM_HOTBAR_LAYOUT = ConfigSettings.addClientSetting("custom_hotbar_layout", () -> true, holder -> holder.set(ClientSettingsConfig.getInstance().isCustomHotbarLayout()));
        ICON_BOBBING = ConfigSettings.addClientSetting("icon_bobbing", () -> true, holder -> holder.set(ClientSettingsConfig.getInstance().isIconBobbing()));
        HEARTH_DEBUG = ConfigSettings.addClientSetting("hearth_debug", () -> true, holder -> holder.set(ClientSettingsConfig.getInstance().isHearthDebug()));
        SHOW_CONFIG_BUTTON = ConfigSettings.addClientSetting("show_config_button", () -> true, holder -> holder.set(ClientSettingsConfig.getInstance().showConfigButton()));
        CONFIG_BUTTON_POS = ConfigSettings.addClientSetting("config_button_pos", Vec2i::new, holder -> holder.set(new Vec2i(ClientSettingsConfig.getInstance().getConfigButtonPos().get(0), ClientSettingsConfig.getInstance().getConfigButtonPos().get(1))));
        DISTORTION_EFFECTS = ConfigSettings.addClientSetting("distortion_effects", () -> true, holder -> holder.set(ClientSettingsConfig.getInstance().areDistortionsEnabled()));
        HIGH_CONTRAST = ConfigSettings.addClientSetting("high_contrast", () -> false, holder -> holder.set(ClientSettingsConfig.getInstance().isHighContrast()));
        SHOW_CREATIVE_WARNING = ConfigSettings.addClientSetting("show_creative_warning", () -> true, holder -> holder.set(ClientSettingsConfig.getInstance().showCreativeWarning()));
        HIDE_TOOLTIPS = ConfigSettings.addClientSetting("hide_tooltips", () -> false, holder -> holder.set(ClientSettingsConfig.getInstance().hideTooltips()));
        EXPAND_TOOLTIPS = ConfigSettings.addClientSetting("expand_tooltips", () -> true, holder -> holder.set((Boolean)ClientSettingsConfig.EXPAND_TOOLTIPS.get()));
        SHOW_WATER_EFFECT = ConfigSettings.addClientSetting("show_water_effect", () -> true, holder -> holder.set(ClientSettingsConfig.getInstance().isWaterEffectEnabled()));
        boolean ssLoaded = CompatManager.isSereneSeasonsLoaded();
        SUMMER_TEMPS = ConfigSettings.addSetting("summer_temps", () -> new Double[]{0.0, 0.0, 0.0}, holder -> holder.set(ssLoaded ? WorldSettingsConfig.getInstance().getSummerTemps() : new Double[3]));
        AUTUMN_TEMPS = ConfigSettings.addSetting("autumn_temps", () -> new Double[]{0.0, 0.0, 0.0}, holder -> holder.set(ssLoaded ? WorldSettingsConfig.getInstance().getAutumnTemps() : new Double[3]));
        WINTER_TEMPS = ConfigSettings.addSetting("winter_temps", () -> new Double[]{0.0, 0.0, 0.0}, holder -> holder.set(ssLoaded ? WorldSettingsConfig.getInstance().getWinterTemps() : new Double[3]));
        SPRING_TEMPS = ConfigSettings.addSetting("spring_temps", () -> new Double[]{0.0, 0.0, 0.0}, holder -> holder.set(ssLoaded ? WorldSettingsConfig.getInstance().getSpringTemps() : new Double[3]));
    }

    public static enum Difficulty {
        SUPER_EASY(() -> Map.of(ConfigSettings.getKey(MIN_TEMP), () -> Temperature.convert(40.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(MAX_TEMP), () -> Temperature.convert(120.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(TEMP_RATE), () -> 0.5, ConfigSettings.getKey(REQUIRE_THERMOMETER), () -> false, ConfigSettings.getKey(FIRE_RESISTANCE_ENABLED), () -> true, ConfigSettings.getKey(ICE_RESISTANCE_ENABLED), () -> true)),
        EASY(() -> Map.of(ConfigSettings.getKey(MIN_TEMP), () -> Temperature.convert(45.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(MAX_TEMP), () -> Temperature.convert(110.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(TEMP_RATE), () -> 0.75, ConfigSettings.getKey(REQUIRE_THERMOMETER), () -> false, ConfigSettings.getKey(FIRE_RESISTANCE_ENABLED), () -> true, ConfigSettings.getKey(ICE_RESISTANCE_ENABLED), () -> true)),
        NORMAL(() -> Map.of(ConfigSettings.getKey(MIN_TEMP), () -> Temperature.convert(50.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(MAX_TEMP), () -> Temperature.convert(100.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(TEMP_RATE), () -> 1.0, ConfigSettings.getKey(REQUIRE_THERMOMETER), () -> true, ConfigSettings.getKey(FIRE_RESISTANCE_ENABLED), () -> true, ConfigSettings.getKey(ICE_RESISTANCE_ENABLED), () -> true)),
        HARD(() -> Map.of(ConfigSettings.getKey(MIN_TEMP), () -> Temperature.convert(55.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(MAX_TEMP), () -> Temperature.convert(90.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(TEMP_RATE), () -> 1.25, ConfigSettings.getKey(REQUIRE_THERMOMETER), () -> true, ConfigSettings.getKey(FIRE_RESISTANCE_ENABLED), () -> false, ConfigSettings.getKey(ICE_RESISTANCE_ENABLED), () -> false)),
        CUSTOM(() -> Map.of());

        private final Supplier<Map<String, Supplier<?>>> settingsSupplier;
        private Map<String, Supplier<?>> settings;

        private Difficulty(Supplier<Map<String, Supplier<?>>> settings) {
            this.settingsSupplier = settings;
        }

        private void ensureSettingsGenerated() {
            if (this.settings == null) {
                this.settings = this.settingsSupplier.get();
            }
        }

        public <T> T getSetting(String id) {
            this.ensureSettingsGenerated();
            return (T)this.settings.get(id).get();
        }

        public <T> T getSetting(DynamicHolder<T> config) {
            this.ensureSettingsGenerated();
            return (T)this.settings.get(ConfigSettings.getKey(config)).get();
        }

        public <T> T getOrDefault(String id, T defaultValue) {
            this.ensureSettingsGenerated();
            return (T)this.settings.getOrDefault(id, () -> defaultValue).get();
        }

        public <T> T getOrDefault(DynamicHolder<T> config, T defaultValue) {
            this.ensureSettingsGenerated();
            return (T)this.settings.getOrDefault(ConfigSettings.getKey(config), () -> defaultValue).get();
        }

        public void load() {
            this.ensureSettingsGenerated();
            this.settings.forEach((id, loader) -> ConfigSettings.getSetting(id).setUnsafe(loader.get()));
        }

        public int getId() {
            return this.ordinal();
        }

        public static Difficulty byId(int id) {
            return Difficulty.values()[id];
        }

        public static Component getFormattedName(Difficulty difficulty) {
            return switch (difficulty) {
                case SUPER_EASY -> Component.m_237115_((String)"cold_sweat.config.difficulty.super_easy.name");
                case EASY -> Component.m_237115_((String)"cold_sweat.config.difficulty.easy.name");
                case NORMAL -> Component.m_237115_((String)"cold_sweat.config.difficulty.normal.name");
                case HARD -> Component.m_237115_((String)"cold_sweat.config.difficulty.hard.name");
                default -> Component.m_237115_((String)"cold_sweat.config.difficulty.custom.name");
            };
        }
    }
}

